@props([
    'label' => 'Demo',
    'icon' => 'fe fe-folder',
    'active' => false,
    'submenus' => [],
])
<li class="slide">
    <a class="side-menu__item {{activeNav($active)}}" data-bs-toggle="slide" href="javascript:void(0)"><i
            class="side-menu__icon {{$icon}}"></i><span
            class="side-menu__label">{{$label}}</span><i class="angle fe fe-chevron-right"></i></a>
    <ul class="slide-menu" style="display: {{toggleNav($active)}}">
        <li class="side-menu-label1"><a href="javascript:void(0)">{{$label}}</a></li>
        @foreach ($submenus as $submenu)
            @isset($submenu['permission'])
                @can($submenu['permission'])
                    <li>
                        <a href="{{ $submenu['route'] }}" @class([
                            'slide-item',
                            'active' => url()->current() == $submenu['route']
                        ])>
                            {{ $submenu['label'] }}
                        </a>
                    </li>
                @endcan
            @else
                <li>
                    <a href="{{ $submenu['route'] }}" @class([
                        'slide-item',
                        'active' => url()->current() == $submenu['route']
                    ])>
                        {{ $submenu['label'] }}
                    </a>
                </li>
            @endisset
        @endforeach
    </ul>
</li>
